/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.evolvedmekanism.config;

import mekanism.api.math.FloatingLong;
import mekanism.common.config.BaseMekanismConfig;
import mekanism.common.config.IMekanismConfig;
import mekanism.common.config.value.CachedFloatingLongValue;
import mekanism.common.config.value.CachedIntValue;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.config.ModConfig;

public class EMGeneralConfig
extends BaseMekanismConfig {
    private static final String APT_CATEGORY = "apt";
    private final ForgeConfigSpec configSpec;
    public final CachedIntValue aptInputStorage;
    public final CachedIntValue aptDefaultDuration;
    public final CachedFloatingLongValue aptEnergyStorage;
    public final CachedFloatingLongValue aptEnergyConsumption;

    EMGeneralConfig() {
        ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
        builder.comment("General Config. This config is synced from server to client.").push("general");
        builder.comment("APT Settings").push(APT_CATEGORY);
        this.aptInputStorage = CachedIntValue.wrap((IMekanismConfig)this, (ForgeConfigSpec.ConfigValue)builder.comment("How much gas (in mB) can the input tank hold.").defineInRange("inputPerAntimatter", 5000, 1, Integer.MAX_VALUE));
        this.aptDefaultDuration = CachedIntValue.wrap((IMekanismConfig)this, (ForgeConfigSpec.ConfigValue)builder.comment("Duration of a recipe (in ticks). Formula: defaultDuration * (gasInputAmount / 100)").defineInRange("defaultDuration", 200, 1, Integer.MAX_VALUE));
        this.aptEnergyStorage = CachedFloatingLongValue.define((IMekanismConfig)this, (ForgeConfigSpec.Builder)builder, (String)"Amount of energy (in Joules) which can be stored in the APT.", (String)"energyStorage", (FloatingLong)FloatingLong.createConst((long)10000000L));
        this.aptEnergyConsumption = CachedFloatingLongValue.define((IMekanismConfig)this, (ForgeConfigSpec.Builder)builder, (String)"Energy needed (in Joules) per tick to process the recipe.", (String)"energyPerInput", (FloatingLong)FloatingLong.createConst((long)100000L));
        builder.pop();
        builder.pop();
        this.configSpec = builder.build();
    }

    public String getFileName() {
        return "general";
    }

    public ForgeConfigSpec getConfigSpec() {
        return this.configSpec;
    }

    public ModConfig.Type getConfigType() {
        return ModConfig.Type.SERVER;
    }
}

